//Scripted by Jumpnjahosofat
//This file is part of the Urshaabi Gauntlet System
//I do not take complete credit for all of the files.  Many are modified RunUO scripts.
//This system is intended for drop in purposes so that it's easy for everyone to enjoy it.
//If you encounter problems, please leave me a message on the forum or my email - uo_cecil@yahoo.com
//Enjoy!!

using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "the corpse of Urshanabi" )]
	public class Urshanabi : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.MortalStrike : WeaponAbility.CrushingBlow;
		}

		[Constructable]
		public Urshanabi() : base(AIType.AI_Necromage, FightMode.Closest, 10, 5, 0.2, 0.4)
		{
			Name = "Urshanabi";
			Title = "the Gauntlet Lord";
			Body = 183;
			BaseSoundID = 0x48D;

			SetStr(900, 1500);
			SetDex(51, 75);
			SetInt(900, 1050);

			SetHits(13000);
			SetMana(8651, 9975);
			SetDamage(20, 40);

			SetDamageType(ResistanceType.Physical, 50);
			SetDamageType(ResistanceType.Cold, 50);

			SetResistance(ResistanceType.Physical, 55);
			SetResistance(ResistanceType.Fire, 60);
			SetResistance(ResistanceType.Cold, 60);
			SetResistance(ResistanceType.Poison, 100);
			SetResistance(ResistanceType.Energy, 60);

			SetSkill(SkillName.DetectHidden, 80.0);
			SetSkill(SkillName.Magery, 200.0);
			SetSkill(SkillName.Meditation, 100.0);
			SetSkill(SkillName.EvalInt, 200.0);
			SetSkill(SkillName.MagicResist, 50.1, 75.0);
			SetSkill(SkillName.Tactics, 110.0, 130.5);
			SetSkill(SkillName.Wrestling, 100.0);
			SetSkill(SkillName.Swords, 120.0);
			SetSkill(SkillName.Necromancy, 200.0);
			SetSkill(SkillName.SpiritSpeak, 200.0);
			SetSkill(SkillName.Parry, 95.0, 120.5);

			Fame = 32000;
			Karma = -20000;

			VirtualArmor = 60;

			int Barva = 337;
			BoneChest chest = new BoneChest();
			chest.Hue = Barva;
			AddItem(chest);
			BoneArms arms = new BoneArms();
			arms.Hue = Barva;
			AddItem(arms);
			BoneGloves gloves = new BoneGloves();
			gloves.Hue = Barva;
			AddItem(gloves);
			BoneLegs legs = new BoneLegs();
			legs.Hue = Barva;
			AddItem(legs);
			BoneHelm helm = new BoneHelm();
			helm.Hue = Barva;
			AddItem(helm);
			Cloak cloak = new Cloak();
			cloak.Hue = Barva;
			AddItem(cloak);
			Katana katana = new Katana();
			katana.Hue = Barva;
			AddItem(katana);
			HeaterShield heatershield = new HeaterShield();
			heatershield.Hue = Barva;
			AddItem(heatershield);

			PackNecroReg(10, 30);
			PackNecroReg(10, 30);
			PackNecroReg(10, 30);
			PackGold(2000);
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.AosSuperBoss, 2);
		}

		public override void OnDeath(Container c)
		{
			base.OnDeath(c);

			if (Utility.RandomBool())
			{
				Container bag = new Bag();
				bag.DropItem(Loot.RandomLevelItem(true));
				bag.Hue = 100;
				c.DropItem(bag);
				c.DropItem(new TeragonChest(this.Name, TreasureMapLevel));
				c.DropItem(new Tokens(150));
			}
			else
			{
				Container bag2 = new Bag();
				Item item = (Item)Activator.CreateInstance(Teragon.Artifacts[Utility.Random(Teragon.Artifacts.Length)]);
				bag2.DropItem(item);
				bag2.Hue = 67;
				c.DropItem(bag2);
				c.DropItem(new PowerScroll());
				c.DropItem(new Tokens(200));
			}

			c.DropItem(new RandomTalisman());
		}

		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool AlwaysMurderer { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (Utility.RandomDouble() < 0.05)
				Summon();

			if (from != null && from != this && 0.1 > Utility.RandomDouble())
				WebAttack(this, from);

				// teleports player near
			if (from is PlayerMobile && !InRange(from.Location, 1) && Utility.RandomDouble() < 0.2)
			{
				Combatant = from;

				from.MoveToWorld(Location, Map);
				from.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				from.PlaySound(0x1FE);
			}
		}

		public override void OnGotMeleeAttack(Mobile attacker)
		{
			base.OnGotMeleeAttack(attacker);
			attacker.Stam -= Utility.Random(5, 10);
		}

		public static void WebAttack(Mobile from, Mobile to)
		{
			Map map = from.Map;

			if (map == null)
				return;

			int x = to.X + Utility.RandomMinMax(-1, 1);
			int y = to.Y + Utility.RandomMinMax(-1, 1);
			int z = to.Z;

			SelfDeletingItem web = new SelfDeletingItem(14273, "a glow", 5);

			from.MovingEffect(to, 14273, 7, 1, false, false, 0x481, 0);
			to.Paralyze(TimeSpan.FromSeconds(6));
			to.SendMessage("Jsi {0} vybojem nezname energie!", (to.Female) ? "paralyzovana" : "paralyzovan");
			web.MoveToWorld(new Point3D(x, y, z), map);
			to.ApplyPoison(from, Poison.Lesser);
		}

		public void Summon()
		{
			Map map = this.Map;

			if (map == null)
				return;

			int newSummon = Utility.RandomMinMax(2, 4);

			for (int i = 0; i < newSummon; ++i)
			{
				Mobile summon = null;

				switch (Utility.Random(5))
				{
					case 0: summon = new SumDaemon(); break;
					case 1: summon = new SumMummy(); break;
					case 2: summon = new BlackLichWraith(); break;
					case 3: summon = new SumBladeSpirits(); break;
					case 4: summon = new SumPoisonElemental(); break;
				}

				if (summon == null)
					summon = new SumDaemon();

				bool validLocation = false;
				Point3D loc = this.Location;

				for (int j = 0; !validLocation && j < 10; ++j)
				{
					int x = X + Utility.Random(3) - 1;
					int y = Y + Utility.Random(3) - 1;
					int z = map.GetAverageZ(x, y);

					if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
						loc = new Point3D(x, y, Z);
					else if (validLocation = map.CanFit(x, y, z, 16, false, false))
						loc = new Point3D(x, y, z);
				}

				// 				summon.Team = this.Team;
				summon.MoveToWorld(loc, map);
				summon.Combatant = null;
			}
		}

		public override void OnGaveMeleeAttack(Mobile defender)
		{
			base.OnGaveMeleeAttack(defender);

			if (0.3 > Utility.RandomDouble())
			{
				/* Maniacal laugh
				 * Cliloc: 1070840
				 * Effect: Type: "3" From: "0x57D4F5B" To: "0x0" ItemId: "0x37B9" ItemIdName: "glow" FromLocation: "(884 715, 10)" ToLocation: "(884 715, 10)" Speed: "10" Duration: "5" FixedDirection: "True" Explode: "False"
				 * Paralyzes for 4 seconds, or until hit
				 */

				defender.FixedEffect(0x37B9, 10, 5);
				defender.SendLocalizedMessage(1070840); // You are scared stiff as you gaze at the master of the Gauntlet.

				defender.Paralyze(TimeSpan.FromSeconds(4.0));
			}
		}

		public override void AlterMeleeDamageFrom(Mobile from, ref int damage)
		{
			AOS.Damage(from, this, (damage / 2), 100, 0, 0, 0, 0);
		}

		public Urshanabi(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}